document.addEventListener('DOMContentLoaded', function() {
    
    const diceContainer = document.getElementById('dice-container');
    const rollButton = document.getElementById('roll-button');
    const resetButton = document.getElementById('reset-button');
    const currentScoreElement = document.getElementById('current-score');
    const remainingAttemptsElement = document.getElementById('remaining-attempts');
    const resultElement = document.getElementById('result');
    const targetScoreElement = document.getElementById('target-score');
    
    
    let diceValues = [];
    let totalScore = 0;
    let remainingAttempts = 3;
    const targetScore = 15;
    const diceCount = 6;
    
    
    targetScoreElement.textContent = targetScore;
    
    
    function initializeDice() {
        diceContainer.innerHTML = '';
        diceValues = [];
        
        for (let i = 0; i < diceCount; i++) {
            const dice = document.createElement('div');
            dice.className = 'dice';
            dice.setAttribute('data-value', '0');
            dice.textContent = '?';
            diceContainer.appendChild(dice);
            diceValues.push(0);
        }
    }
    
    
    function rollDice() {
        
        remainingAttempts--;
        remainingAttemptsElement.textContent = remainingAttempts;
        
        
        const diceElements = document.querySelectorAll('.dice');
        diceElements.forEach(dice => {
            dice.classList.add('rolling');
            dice.textContent = ''; 
        });
        
        
        setTimeout(() => {
            totalScore = 0;
            
            diceElements.forEach((dice, index) => {
                
                const value = Math.floor(Math.random() * 6) + 1;
                diceValues[index] = value;
                totalScore += value;
                
                
                dice.classList.remove('rolling');
                dice.setAttribute('data-value', value);
            });
            
        
            currentScoreElement.textContent = totalScore;
            
        
            checkResult();
            
            
            if (remainingAttempts <= 0) {
                rollButton.disabled = true;
            }
        }, 1000);
    }
    
    
    function checkResult() {
        resultElement.className = 'result';
        
        if (totalScore >= targetScore) {
            resultElement.textContent = `Erfolg! Du hast ${totalScore} Punkte erreicht.`;
            resultElement.classList.add('success');
            rollButton.disabled = true;
        } else {
            resultElement.textContent = `Nicht genug Punkte! Du hast nur ${totalScore} Punkte.`;
            resultElement.classList.add('failure');
            
            if (remainingAttempts <= 0) {
                resultElement.textContent += ' Keine Versuche mehr übrig.';
            }
        }
    }
    
    
    function resetGame() {
        totalScore = 0;
        remainingAttempts = 3;
        
        currentScoreElement.textContent = totalScore;
        remainingAttemptsElement.textContent = remainingAttempts;
        
        resultElement.textContent = '';
        resultElement.className = 'result';
        
        rollButton.disabled = false;
        
        initializeDice();
    }
    

    rollButton.addEventListener('click', rollDice);
    resetButton.addEventListener('click', resetGame);
    

    initializeDice();
})